<?php

namespace Import\ApiBundle\Entity;

use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * PKD
 *
 * @Gedmo\Tree(type="nested")
 * @ORM\Table(name="pkd")
 * use repository for handy tree functions
 * @ORM\Entity(repositoryClass="Import\ApiBundle\Repository\PKDRepository")
 *
 * @ExclusionPolicy("all")
 */
class PKD
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"pkdList","companyDetails"})
     */
    private $id;

    /**
     * @var string $symbol
     *
     * @ORM\Column(name="symbol", type="string", length=30)
     *
     * @Expose
     * @AnnotationGroups({"pkdList","companyDetails"})
     */
    private $symbol;

    /**
     * @var string $title
     *
     * @ORM\Column(name="title", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"pkdList","companyDetails"})
     */
    private $title;

    /**
     * @Gedmo\TreeLeft
     * @ORM\Column(name="lft", type="integer")
     */
    private $lft;

    /**
     * @Gedmo\TreeLevel
     * @ORM\Column(name="lvl", type="integer")
     */
    private $lvl;

    /**
     * @Gedmo\TreeRight
     * @ORM\Column(name="rgt", type="integer")
     */
    private $rgt;

    /**
     * @Gedmo\TreeRoot
     * @ORM\Column(name="root", type="integer", nullable=true)
     */
    private $root;

    /**
     * @var integer
     *
     * @ORM\Column(name="market_segment_id", type="integer", nullable=true)
     */
    private $marketSegmentId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="active", type="boolean")
     *
     * @Expose
     * @AnnotationGroups({"pkdList"})
     */
    private $active = false;

    /**
     * @Gedmo\TreeParent
     * @ORM\ManyToOne(targetEntity="PKD", inversedBy="children")
     * @ORM\JoinColumn(name="parent_id", referencedColumnName="id", onDelete="CASCADE")
     */
    private $parent;

    /**
     * @ORM\OneToMany(targetEntity="PKD", mappedBy="parent")
     * @ORM\OrderBy({"lft" = "ASC"})
     */
    private $children;

    /**
     * @ORM\ManyToOne(targetEntity="\VM\ApiBundle\Entity\MarketSegment", inversedBy="codesPkd")
     * @ORM\JoinColumn(name="market_segment_id", referencedColumnName="id")
     */
    protected $marketSegment;

    /**
     * Inverse Side
     *
     * @ORM\ManyToMany(targetEntity="\VM\ApiBundle\Entity\Company", mappedBy="codesPkd")
     */
    private $company;


    public function getId()
    {
        return $this->id;
    }

    public function setTitle($title)
    {
        $this->title = $title;
    }

    public function getTitle()
    {
        return $this->title;
    }

    public function setSymbol($symbol)
    {
        $this->symbol = $symbol;
    }

    public function getSymbol()
    {
        return $this->symbol;
    }

    public function getLvl()
    {
        return $this->lvl;
    }

    public function setParent(PKD $parent = null)
    {
        $this->parent = $parent;
    }

    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->children = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Set lft
     *
     * @param integer $lft
     * @return PKD
     */
    public function setLft($lft)
    {
        $this->lft = $lft;
    
        return $this;
    }

    /**
     * Get lft
     *
     * @return integer 
     */
    public function getLft()
    {
        return $this->lft;
    }

    /**
     * Set lvl
     *
     * @param integer $lvl
     * @return PKD
     */
    public function setLvl($lvl)
    {
        $this->lvl = $lvl;
    
        return $this;
    }

    /**
     * Set rgt
     *
     * @param integer $rgt
     * @return PKD
     */
    public function setRgt($rgt)
    {
        $this->rgt = $rgt;
    
        return $this;
    }

    /**
     * Get rgt
     *
     * @return integer 
     */
    public function getRgt()
    {
        return $this->rgt;
    }

    /**
     * Set root
     *
     * @param integer $root
     * @return PKD
     */
    public function setRoot($root)
    {
        $this->root = $root;
    
        return $this;
    }

    /**
     * Get root
     *
     * @return integer 
     */
    public function getRoot()
    {
        return $this->root;
    }

    /**
     * Set marketSegmentId
     *
     * @param integer $marketSegmentId
     * @return PKD
     */
    public function setMarketSegmentId($marketSegmentId)
    {
        $this->marketSegmentId = $marketSegmentId;
    
        return $this;
    }

    /**
     * Get marketSegmentId
     *
     * @return integer 
     */
    public function getMarketSegmentId()
    {
        return $this->marketSegmentId;
    }

    /**
     * Add children
     *
     * @param \Import\ApiBundle\Entity\PKD $children
     * @return PKD
     */
    public function addChildren(\Import\ApiBundle\Entity\PKD $children)
    {
        $this->children[] = $children;
    
        return $this;
    }

    /**
     * Remove children
     *
     * @param \Import\ApiBundle\Entity\PKD $children
     */
    public function removeChildren(\Import\ApiBundle\Entity\PKD $children)
    {
        $this->children->removeElement($children);
    }

    /**
     * Get children
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getChildren()
    {
        return $this->children;
    }

    /**
     * Set marketSegment
     *
     * @param \VM\ApiBundle\Entity\MarketSegment $marketSegment
     * @return PKD
     */
    public function setMarketSegment(\VM\ApiBundle\Entity\MarketSegment $marketSegment = null)
    {
        $this->marketSegment = $marketSegment;
    
        return $this;
    }

    /**
     * Get marketSegment
     *
     * @return \VM\ApiBundle\Entity\MarketSegment 
     */
    public function getMarketSegment()
    {
        return $this->marketSegment;
    }

    /**
     * Set active
     *
     * @param boolean $active
     * @return PKD
     */
    public function setActive($active)
    {
        $this->active = $active;
    
        return $this;
    }

    /**
     * Get active
     *
     * @return boolean 
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Add company
     *
     * @param \VM\ApiBundle\Entity\Company $company
     * @return PKD
     */
    public function addCompany(\VM\ApiBundle\Entity\Company $company)
    {
        $this->company[] = $company;
    
        return $this;
    }

    /**
     * Remove company
     *
     * @param \VM\ApiBundle\Entity\Company $company
     */
    public function removeCompany(\VM\ApiBundle\Entity\Company $company)
    {
        $this->company->removeElement($company);
    }

    /**
     * Get company
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCompany()
    {
        return $this->company;
    }
}